/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.report;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.IntermediateReport;
import com.ibm.hwmca.fw.report.ReportListener;
import com.ibm.hwmca.fw.util.Trace;

public class ReportListenerAdapter
implements ReportListener {
    private static final String TRACE_MASKT = "XFRMRLAT";
    private static final String TRACE_MASKF = "XFRMRLAF";
    private static final String TRACE_MASKD = "XFRMRLAD";
    private ObjectId[] ids;
    private Object master;
    private CompletionReport[] data;
    private ObjectId[] targets;
    private Throwable thrown = null;
    private boolean gotCompletion = false;
    private Object reportLock = new Object();
    private Object[] oldData;

    public ReportListenerAdapter(Object master2, CompletionReport[] data, ObjectId[] ids) {
        this.master = master2;
        this.data = data;
        if (ids == null) {
            this.ids = new ObjectId[0];
            this.targets = new ObjectId[0];
        } else {
            this.ids = new ObjectId[ids.length];
            this.targets = new ObjectId[ids.length];
            int i = 0;
            while (i < this.targets.length) {
                this.targets[i] = ids[i];
                ++i;
            }
        }
        Trace.trace(TRACE_MASKT, "<> ReportListenerAdapter()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(CompletionReport report) throws IllegalArgumentException {
        if (report == null) {
            throw new IllegalArgumentException("report specified as null");
        }
        Object object = this.reportLock;
        synchronized (object) {
            if (this.ids.length > 0) {
                int i = 0;
                while (i < this.ids.length) {
                    if (this.ids[i] == null) {
                        this.ids[i] = this.targets[i];
                        this.gotCompletion = true;
                        if (this.data != null) {
                            this.data[i] = (CompletionReport)report.clone();
                            this.data[i].setObjectId(this.ids[i]);
                        }
                    }
                    ++i;
                }
            } else {
                this.gotCompletion = true;
                if (this.data != null && this.data.length > 0) {
                    this.data[0] = (CompletionReport)report.clone();
                    this.data[0].setObjectId(null);
                }
            }
        }
        if (this.master != null) {
            Object object2 = this.master;
            synchronized (object2) {
                this.master.notify();
            }
        }
    }

    public boolean isFinished() throws Throwable {
        Trace.trace(TRACE_MASKT, "-> ReportListenerAdapter.isFinished()");
        if (this.thrown != null) {
            throw this.thrown;
        }
        boolean finished = this.gotCompletion;
        int i = 0;
        while (i < this.ids.length && finished) {
            if (this.ids[i] == null) {
                finished = false;
            }
            ++i;
        }
        Trace.trace(TRACE_MASKT, "<- ReportListenerAdapter.isFinished(); " + finished);
        return finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeReport(CompletionReport report) {
        Trace.trace(TRACE_MASKT, "-> ReportListenerAdapter.completeReport()");
        int full = 0;
        Object object = this.reportLock;
        synchronized (object) {
            if (this.ids.length > 0) {
                int i = 0;
                while (i < this.ids.length) {
                    if (report.getObjectId().equals(this.targets[i])) {
                        if (this.ids[i] == null) {
                            this.ids[i] = report.getObjectId();
                            this.gotCompletion = true;
                            if (this.data != null) {
                                this.data[i] = report;
                            }
                            if (this.oldData != null) {
                                this.oldData[i] = report.getData();
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "we already have a completion report for target: " + report.getObjectId());
                        }
                    }
                    if (this.ids[i] != null) {
                        ++full;
                    }
                    ++i;
                }
            } else {
                this.gotCompletion = true;
                if (this.data != null && this.data.length > 0) {
                    this.data[0] = report;
                }
            }
        }
        if (this.master != null && full == this.ids.length) {
            Object object2 = this.master;
            synchronized (object2) {
                this.master.notify();
            }
        }
        Trace.trace(TRACE_MASKT, "<- ReportListenerAdapter.completeReport()");
    }

    public void intermediateReport(IntermediateReport report) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorReport(Throwable thrown) {
        Trace.trace(TRACE_MASKT, "-> ReportListenerAdapter.errorReport()");
        this.thrown = thrown;
        if (this.master != null) {
            Object object = this.master;
            synchronized (object) {
                this.master.notify();
            }
        }
        Trace.trace(TRACE_MASKT, "<- ReportListenerAdapter.errorReport()");
    }
}

